<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\AdminBaseController;
use App\Http\Requests\Admin\Task\StoreRequest;
use App\Models\Task;
use Illuminate\Http\Request;

use App\Classes\Reply;
use App\Http\Requests\Admin\Task\DeleteRequest;
use App\Http\Requests\Admin\TimesheetApproval\UpdateRequest;
use App\Mail\TimesheetApproval;
use Barryvdh\DomPDF\PDF;
use App\Models\Admin;
use App\Models\Employee;
use App\Models\Timesheet;
use Illuminate\Support\Facades\View;

use Illuminate\Support\Facades\DB as DS;

use Yajra\DataTables\Facades\DataTables;

class TimesheetReportsController extends AdminBaseController
{

    public function __construct()
    {
        parent::__construct();
        $this->pageTitle = 'Timesheet Reports';
        $this->timesheetReportsOpen = 'active';
        $this->timesheetReportsActive = 'active';
        $this->pageTitle = 'Timesheet Reports';
    }

    /**
     * @return \Illuminate\Contracts\View\View
     */
    public function index(Request $request)
    {


        $this->employees = Employee::select('id', 'full_name', 'employeeID')
        ->where('status', '=', 'active')
            ->get();
        $this->timesheet = Timesheet::all();
        return View::make('admin.timesheet_reports.index', $this->data);
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function ajaxTimesheetReports(Request $request)
    {

        $startDate = $request->start_date;
        $endDate = $request->end_date;
        $employeeId = $request->employee_id;
        
        $query = "";

        if(empty($startDate)){
            $query = "
            select ts.id, em.full_name, pr.name project, ta.description task, ts.description, ts.clock_in `from`, ts.clock_out `to`, hours from timesheets ts
            inner join projects pr on pr.id  = ts.project_id
            inner join tasks ta on ta.id = ts.task_id
            inner JOIN employees em on em.id = ts.employee_id
           
            ";
        }else{
            $query = "
            select ts.id, em.full_name, pr.name project, ta.description task, ts.description, ts.clock_in `from`, ts.clock_out `to`, hours from timesheets ts
            inner join projects pr on pr.id  = ts.project_id
            inner join tasks ta on ta.id = ts.task_id
            inner JOIN employees em on em.id = ts.employee_id
            where  clock_out between '" . $startDate . " 00:00' and '" . $endDate . " 23:00' and ts.employee_id = $employeeId
            ";
        }


        error_log($query);

        $result = DS::select(
            $query
        );

        foreach($result as $timesheet){
            $timesheet->task = strip_tags($timesheet->task);
        }

        return DataTables::of($result)            
            ->removeColumn('id')            
            ->make(true);
    }


    public function download(Request $request)
    {
        error_log('::::::::::::::::::::::::::::::::::::::::::::' . $request->employee_id);

        $startDate = $request->start_date;
        $endDate = $request->end_date;

        $result = DS::select(
            "
            select ts.id, em.full_name, pr.name project, ta.description task, ts.description, ts.clock_in `from`, ts.clock_out `to`, hours, DATE_FORMAT(ts.clock_out, '%d/%m/%Y') f_date from timesheets ts
            inner join projects pr on pr.id  = ts.project_id
            inner join tasks ta on ta.id = ts.task_id
            inner JOIN employees em on em.id = ts.employee_id
            where em.id = $request->employee_id and clock_out between '$startDate 00:00' and '$endDate 23:00'
            "
        );

        $totalHrs = 0;
        foreach($result as $time){
            $totalHrs += intval($time->hours);
        }

        $this->timesheets = $result;
        $this->employee = Employee::find($request->employee_id);
        $this->totalHrs = $totalHrs ;
        return \PDF::loadView("admin.timesheet_reports.pdfview", $this->data)
            ->download("file_1.pdf");
    }
    
}
