<?php $__env->startSection('head'); ?>
    <style>
        .btn.active {
            opacity: 2 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainarea'); ?>

    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo app('translator')->get("pages.attendances.indexTitle"); ?>
            </h1></div>
        <div class="page-toolbar">
            <!-- BEGIN THEME PANEL -->
            <div class="btn-theme-panel">
                <a onclick="loadView('<?php echo e(route('admin.attendances.index')); ?>')" class="btn <?php echo e(isset($viewAttendanceActive) ? $viewAttendanceActive : ''); ?>">
                    <i class="fa fa-th"></i>
                </a>
                <a onclick="loadView('<?php echo e(route('admin.attendance.employee')); ?>')" class="btn">
                    <i class="fa fa-bars"></i>
                </a>
            </div>
            <!-- END THEME PANEL -->
        </div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active"><?php echo app('translator')->get("pages.attendances.indexTitle"); ?></span>
            </li>

        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">

            <div class="portlet light bordered">
                <div class="portlet-body">
                    <div class="row filter-row">
                        <div class="col-sm-3 col-xs-6">
                            <div class="form-group form-focus">
                                <label class="control-label"><?php echo app('translator')->get('core.employeeName'); ?></label>
                                <select class="form-control select2me" name="employee_id">
                                    <option value="all">All</option>
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->full_name); ?> (<?php echo app('translator')->get('core.empId'); ?>: <?php echo e($employee->employeeID); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>


                            </div>
                        </div>
                        <div class="col-sm-3 col-xs-6">
                            <div class="form-group form-focus">
                                <label class="control-label"><?php echo app('translator')->get('core.selectMonth'); ?></label>
                                <select class="form-control select floating" name="month">
                                    <option value="1"
                                            <?php if(strtolower(date('F'))=='january'): ?>selected='selected'<?php endif; ?> ><?php echo app('translator')->get('core.jan'); ?>
                                    </option>
                                    <option value="2"
                                            <?php if(strtolower(date('F'))=='february'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.feb'); ?>
                                    </option>
                                    <option value="3"
                                            <?php if(strtolower(date('F'))=='march'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.mar'); ?>
                                    </option>
                                    <option value="4"
                                            <?php if(strtolower(date('F'))=='april'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.apr'); ?>
                                    </option>
                                    <option value="5" <?php if(strtolower(date('F'))=='may'): ?>selected='selected'<?php endif; ?>>
                                        <?php echo app('translator')->get('core.may'); ?>
                                    </option>
                                    <option value="6"
                                            <?php if(strtolower(date('F'))=='june'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.jun'); ?>
                                    </option>
                                    <option value="7"
                                            <?php if(strtolower(date('F'))=='july'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.jul'); ?>
                                    </option>
                                    <option value="8"
                                            <?php if(strtolower(date('F'))=='august'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.aug'); ?>
                                    </option>
                                    <option value="9"
                                            <?php if(strtolower(date('F'))=='september'): ?>selected='selected'<?php endif; ?>>
                                        <?php echo app('translator')->get('core.sept'); ?>
                                    </option>
                                    <option value="10"
                                            <?php if(strtolower(date('F'))=='october'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.oct'); ?>
                                    </option>
                                    <option value="11"
                                            <?php if(strtolower(date('F'))=='november'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.nov'); ?>
                                    </option>
                                    <option value="12"
                                            <?php if(strtolower(date('F'))=='december'): ?>selected='selected'<?php endif; ?>><?php echo app('translator')->get('core.dec'); ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3 col-xs-6">
                            <div class="form-group form-focus">
                                <label class="control-label"><?php echo app('translator')->get('core.selectYear'); ?></label>
                                <?php echo Form::selectYear('year', 2015, date('Y'),date('Y'),['class' => 'form-control select floating']); ?>

                            </div>
                        </div>
                        <div class="col-sm-3 col-xs-6">
                            <div class="form-group form-focus">
                                <label class="control-label">&nbsp;</label>
                                <a href="javascript:;" class="btn btn-success btn-block" onclick="filter(); return false;"> Search </a>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive" id="attendance-sheet">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerjs'); ?>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script("assets/hr/js/select2.min.js"); ?>


    <!-- END PAGE LEVEL PLUGINS -->
    <script type="text/javascript">
       var filter = () => {
            var data = {
                employee_id: $("select[name='employee_id']").val(),
                month: $("select[name='month']").val(),
                year: $("select[name='year']").val(),
                _token: '<?php echo e(csrf_token()); ?>'
            };

            var url = "<?php echo e(route('admin.attendance.filter')); ?>";
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '#attendance-sheet',
                data: data,
                success: function (res) {
                    if (res.status === 'success') {
                        $('#attendance-sheet').html(res.data);
                    }
                }
            });
        };
       jQuery(document).ready(function () {
           filter();
       });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/attendances/attendance-sheet.blade.php ENDPATH**/ ?>