<?php $__env->startSection('head'); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>

<!-- BEGIN PAGE HEADER-->
<div class="page-head">
    <div class="page-title">
        <h1>
            <?php echo e($pageTitle); ?>

        </h1>
    </div>
</div>
<div class="page-bar">
    <ul class="page-breadcrumb breadcrumb">
        <li>
            <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.home')); ?></a>
            <i class="fa fa-circle"></i>
        </li>

        <li>
            <span class="active"> <?php echo e(trans('core.settings')); ?></span>
        </li>
    </ul>
</div>
<!-- END PAGE HEADER-->
<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->

        <div id="load">

            

            


        </div>
        <div class="portlet light bordered">

            <div class="portlet-body form">

                <!------------------------ BEGIN FORM---------------------->
                <?php echo Form::model($setting, ['method' => 'POST','class'=>'form-horizontal', 'id' => 'updateSettings']); ?>


                <div id="alert">
                    <?php if($setting->mail_driver =='smtp'): ?>
                    <?php if($setting->verified): ?>
                    <div class="alert alert-success"><?php echo e(__('messages.smtpSuccess')); ?></div>
                    <?php else: ?>
                    <div class="alert alert-danger"><?php echo e(__('messages.smtpError')); ?></div>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>

                <input type="hidden" name="type" value="smtpSetting">
                <div class="form-body">

                    <div class="form-group">
                        <label class="col-md-2 control-label">MAIL DRIVER:
                        </label>
                        <div class="col-md-6">
                            <label class="radio-inline"><input type="radio" class="checkbox"
                                    onchange="getDriverValue(this);" value="mail" <?php if($setting->mail_driver == 'mail'): ?>
                                checked
                                <?php endif; ?> name="mail_driver">Mail</label>
                            <label class="radio-inline m-l-10"><input type="radio" onchange="getDriverValue(this);"
                                    value="smtp" <?php if($setting->mail_driver == 'smtp'): ?> checked
                                <?php endif; ?> name="mail_driver">SMTP</label>
                        </div>


                    </div>
                    <div id="smtp_div">
                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.mailHost')); ?>:
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="mail_host" placeholder=""
                                    value="<?php echo e($setting->mail_host); ?>">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.mailPort')); ?>:</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="mail_port"
                                    value="<?php echo e($setting->mail_port); ?>" placeholder="">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.mailUsername')); ?>:</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="mail_username"
                                    value="<?php echo e($setting->mail_username); ?>" placeholder="">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.mailPassword')); ?>:</label>
                            <div class="col-md-6">
                                <input type="password" class="form-control" name="mail_password"
                                    value="<?php echo e($setting->mail_password); ?>" placeholder="">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.mailEncryption')); ?>:</label>
                            <div class="col-md-6">
                                <?php echo Form::select('mail_encryption', ['' => 'None', 'tls' => 'TLS', 'ssl' => 'SSL'],
                                \old('mail_encryption'),['class'=>'form-control']); ?>

                                <span class="help-block"></span>
                            </div>
                        </div>

                        <!------------------------- END FORM ----------------------->

                    </div>
                </div>
                <div class="form-actions">
                    <div class="form-group">
                        <label class="col-md-2 control-label">From Name:</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="mail_from_name"
                                value="<?php echo e($setting->mail_from_name); ?>" placeholder="">
                            <span class="help-block"></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-2 control-label">From Email:</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="mail_from_email"
                                value="<?php echo e($setting->mail_from_email); ?>" placeholder="">
                            <span class="help-block"></span>
                        </div>
                    </div>



                    <div class="row">
                        <div class="col-md-offset-2 col-md-1">
                            <button type="submit" onclick="smtpSetting();return false;"
                                class="btn green"><?php echo e(trans('core.btnUpdate')); ?></button>

                        </div>
                        <div class="col-md-4">
                            <button type="submit" onclick="showModal();return false;"
                                class="btn blue"><?php echo e(trans('core.btnSendTestMail')); ?></button>

                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
</div>
<!-- END PAGE CONTENT-->

<div id="showModal" class="modal fade" tabindex="-1" data-backdrop="static_approve" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Send test email to below email address</h4>
            </div>
            <div class="modal-body">
                <!------------------------ BEGIN FORM---------------------->
                <?php echo Form::open(['method' => 'POST','class'=>'form-horizontal', 'id' => 'testEmail']); ?>

                <div class="form-body">

                    <div class="form-group">
                        <label class="col-md-3 control-label">Email:
                        </label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="test_email" value="<?php echo e($setting->email); ?>">
                            <span class="help-block"></span>
                        </div>
                    </div>


                </div>


            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn dark btn-outline"><?php echo app('translator')->get('core.btnCancel'); ?></button>
                <input type="button" name="application_status" id="confirm" class="btn green"
                    value="<?php echo app('translator')->get('core.btnSubmit'); ?>">
            </div>
            <?php echo Form::close(); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerjs'); ?>

<script>
    function smtpSetting() {

            var url = '<?php echo e(route('admin.email-settings.updateMailConfig')); ?>';

            $.easyAjax({
                url: url,
                type: "POST",
                container: '#updateSettings',
                messagePosition: "inline",
                data: $('#updateSettings').serialize(),
                success: function (response) {
                    if (response.status == 'error') {
                        $('#alert').prepend('<div class="alert alert-danger"><?php echo e(__('messages.smtpError')); ?></div>')
                    } else {
                        $('#alert').show();
                    }
                }
            })

        }


        function showModal() {
            $('#showModal').modal('show');
            $('#showModal').find("#confirm").off().click(function () {

                var url = "<?php echo e(route('admin.smtp_settings.send-test-email')); ?>";
                $.easyAjax({
                    type: 'POST',
                    url: url,
                    container: '#testEmail',
                    messagePosition: 'inline',
                    data: $('#testEmail').serialize(),
                });

            });
        }

        function getDriverValue(sel) {
            if (sel.value == 'mail') {
                $('#smtp_div').hide();
                $('#alert').hide();
            } else {
                $('#smtp_div').show();
                $('#alert').show();
            }
        }

        <?php if($setting->mail_driver == 'mail'): ?>
        $('#smtp_div').hide();
        $('#alert').hide();
        <?php endif; ?>
</script>
<!-- END PAGE LEVEL PLUGINS -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/settings/smtp.blade.php ENDPATH**/ ?>