<?php $__env->startSection('head'); ?>
<?php echo HTML::style('assets/admin/pages/css/pricing.css'); ?>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


        <!-- BEGIN PAGE HEADER-->
<div class="page-head"><div class="page-title"><h1>
            <?php echo app('translator')->get("pages.billing.plans"); ?>
        </h1></div></div>
<div class="page-bar">
    <ul class="page-breadcrumb breadcrumb">
        <li>
            <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.dashboard')); ?></a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <span class="active"><?php echo app('translator')->get("pages.billing.plans"); ?></span>
        </li>

    </ul>

</div>
<!-- END PAGE HEADER-->
<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-md-12">
        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>
        <div class="page-content-inner">
            <div class="portlet light portlet-fit ">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-share font-green"></i>
                        <span class="caption-subject font-green bold uppercase">Monthly Plans</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="pricing-content-1">
                        <div class="row">
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                <div class="price-column-container border-active">
                                    <div class="price-table-head bg-blue">
                                        <h2 class="no-margin"><?php echo e($plan->plan_name); ?></h2>
                                    </div>
                                    <div class="arrow-down border-top-blue"></div>
                                    <div class="price-table-pricing">
                                        <h3>
                                            <sup class="price-sign"><?php echo e($setting->currency_symbol); ?></sup><?php echo e($plan->monthly_price); ?></h3>
                                        <p>per month</p>
                                        <?php if($loggedAdmin->company->subscriptionPlan && $loggedAdmin->company->subscriptionPlan->id == $plan->id && $loggedAdmin->company->package_type == 'monthly' && $loggedAdmin->company->license_expired != 1): ?>
                                            <div class="price-ribbon">Selected</div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="price-table-content">
                                        <div class="row mobile-padding">
                                            <div class="col-xs-3 text-right mobile-padding">
                                                <i class="icon-user"></i>
                                            </div>
                                            <div class="col-xs-9 text-left mobile-padding"><?php echo e($plan->start_user_count); ?> - <?php echo e($plan->end_user_count); ?> Users</div>
                                        </div>
                                    </div>
                                    <div class="arrow-down arrow-grey"></div>
                                    <?php if(round($plan->monthly_price) > 0 && ($setting->stripe_status == 1 || $setting->paypal_status == 1)): ?>
                                        <div class="price-table-footer">
                                            <?php if($loggedAdmin->company->subscriptionPlan && $loggedAdmin->company->subscriptionPlan->id == $plan->id && $loggedAdmin->company->package_type == 'monthly' && $loggedAdmin->company->license_expired != 1): ?>
                                                -
                                            <?php else: ?>
                                                <button type="button" data-package-id="<?php echo e($plan->id); ?>" data-package-type="monthly" class="btn grey-salsa btn-outline sbold uppercase price-button selectPackage">Subscribe</button>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="price-table-footer">
                                            -
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="page-content-inner">
            <div class="portlet light portlet-fit ">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-share font-green"></i>
                        <span class="caption-subject font-green bold uppercase">Yearly Plans</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="pricing-content-1">
                        <div class="row">
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="price-column-container border-active">
                                        <div class="price-table-head bg-blue">
                                            <h2 class="no-margin"><?php echo e($plan->plan_name); ?></h2>
                                        </div>
                                        <div class="arrow-down border-top-blue"></div>
                                        <div class="price-table-pricing">
                                            <h3>
                                                <sup class="price-sign"><?php echo e($setting->currency_symbol); ?></sup><?php echo e($plan->annual_price); ?></h3>
                                            <p>per year</p>
                                            <?php if($loggedAdmin->company->subscriptionPlan && $loggedAdmin->company->subscriptionPlan->id == $plan->id && $loggedAdmin->company->package_type == 'annual' && $loggedAdmin->company->license_expired != 1): ?>
                                                <div class="price-ribbon">Selected</div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="price-table-content">
                                            <div class="row mobile-padding">
                                                <div class="col-xs-3 text-right mobile-padding">
                                                    <i class="icon-user"></i>
                                                </div>
                                                <div class="col-xs-9 text-left mobile-padding"><?php echo e($plan->start_user_count); ?> - <?php echo e($plan->end_user_count); ?> Users</div>
                                            </div>
                                        </div>
                                        <div class="arrow-down arrow-grey"></div>
                                        <div class="price-table-footer">
                                            <?php if(round($plan->annual_price) > 0 && ($setting->stripe_status == 1 || $setting->paypal_status == 1)): ?>
                                                <div class="price-table-footer">
                                                    <?php if($loggedAdmin->company->subscriptionPlan && $loggedAdmin->company->subscriptionPlan->id == $plan->id && $loggedAdmin->company->package_type == 'annual' && $loggedAdmin->company->license_expired != 1): ?>
                                                        -
                                                    <?php else: ?>
                                                        <button type="button" data-package-id="<?php echo e($plan->id); ?>" data-package-type="annual" class="btn grey-salsa btn-outline sbold uppercase price-button selectPackage">Subscribe</button>
                                                    <?php endif; ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="price-table-footer">
                                                    -
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
        
        <div class="modal fade bs-modal-md in" id="package-select-form" role="dialog" aria-labelledby="myModalLabel"
             aria-hidden="true">
            <div class="modal-dialog modal-md" id="modal-data-application">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                        <span class="caption-subject font-red-sunglo bold uppercase" id="modelHeading"></span>
                    </div>
                    <div class="modal-body">
                        Loading...
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn default" data-dismiss="modal">Close</button>
                        <button type="button" class="btn blue">Save changes</button>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        

<?php $__env->stopSection(); ?>



<?php $__env->startSection('footerjs'); ?>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script('assets/global/plugins/uniform/jquery.uniform.min.js'); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/datatables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/responsive/dataTables.responsive.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/responsive/responsive.bootstrap.js"); ?>

    <?php echo HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/select2/js/select2.js"); ?>

    <?php echo HTML::script('assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js'); ?>

    <?php echo HTML::script('assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js'); ?>

    <?php echo HTML::script('assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js'); ?>

    <script src="https://js.stripe.com/v3/" type="text/javascript"></script>

<script>
    // Show Create Holiday Modal
    $('body').on('click', '.selectPackage', function(){
        var id = $(this).data('package-id');
        var type = $(this).data('package-type');
        var url = "<?php echo e(route('admin.billing.select-package',':id')); ?>?type="+type;
        url = url.replace(':id', id);
        $.ajaxModal('#package-select-form', url);
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/billing/change_plan.blade.php ENDPATH**/ ?>