<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\AdminBaseController;
use App\Http\Requests\Admin\Task\StoreRequest;
use App\Models\Task;
use Illuminate\Http\Request;

use App\Classes\Reply;
use App\Http\Requests\Admin\Task\DeleteRequest;
use App\Http\Requests\Admin\TimesheetApproval\UpdateRequest;
use App\Mail\TimesheetApproval;
use App\Models\Admin;
use App\Models\Employee;
use App\Models\Timesheet;
use Illuminate\Support\Facades\Session as FacadesSession;
use Illuminate\Support\Facades\View;

use Illuminate\Support\Facades\DB as DS;

use Yajra\DataTables\Facades\DataTables;

class TimesheetApprovalController extends AdminBaseController
{

    public function __construct()
    {
        parent::__construct();
        $this->pageTitle = 'Timesheet Approval';
        $this->timesheetApprovalOpen = 'active';
        $this->timesheetApprovalActive = 'active';
        $this->pageTitle = 'Timesheet Approval';
    }

    /**
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $this->timesheet = Timesheet::all();
        return View::make('admin.timesheet_approval.index', $this->data);
    }

    /**
     * @return mixed
     * @throws \Exception
     */
    public function ajaxTimesheetApproval()
    {

        $approver_level = '';
        if (admin()) {
            $approver_level = admin()->approver_level;
        }

        $result = DS::select(
            "
            select ts.id, em.full_name, pr.name project, ta.description task,  ts.clock_in `from`, ts.clock_out `to`, hours from timesheets ts
            inner join projects pr on pr.id  = ts.project_id
            inner join tasks ta on ta.id = ts.task_id
            inner JOIN employees em on em.id = ts.employee_id
            where approver_level='$approver_level'
            "
        );

        return DataTables::of($result)
            ->addColumn('edit', function ($row) {
                return '<a  class="btn purple btn-sm margin-bottom-10"  onclick="showEdit(' . $row->id . ')"><i class="fa fa-edit"></i> <span class="hidden-sm hidden-xs">' . trans("core.btnViewEdit") . '</span></a>
                          ';
            })
            ->removeColumn('id')
            ->rawColumns(['edit'])
            ->escapeColumns(['edit'])
            ->make(true);
    }


    


    /**
     * @param $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $this->timesheet = Timesheet::find($id);
        $task = Task::find($this->timesheet->task_id);
        error_log('task id:::::::::::::::::::::::' . $task->id);
        $this->data['task'] = $task->description;
        return View::make('admin.timesheet_approval.edit', $this->data);
    }


    /**
     * @param UpdateRequest $request
     * @param $id
     * @return array
     */
    public function update(UpdateRequest $request, $id)
    {
        $timesheet = Timesheet::findOrFail($id);
        if ($request->status == 'Approve' && $timesheet->approver_level == 'level_1') {



            //Prompt level 2 approvers to approve
            //        Send email to all admins
            $admins = Admin::select('email', 'approver_level')->where('company_id', admin()->company_id)->get();

            error_log("admins count:::::::::::" . count($admins));

            
            
            error_log(":::::::::::::::collected basics:::::::::::");

            foreach ($admins as $admin) {

                error_log('approver levels =============== ' . $admin->email . '================>' . $admin->approver_level);
                if ($admin->approver_level == 'level_2') {

                    $this->replyTo = $admin->email;

                    

                    $this->email = $admin->email;


                    $task = Task::find($request->task_id);

                    $this->data['clock_in'] = $timesheet->clock_in;
                    $this->data['clock_out'] = $timesheet->clock_out;
                    $this->data['task'] = $task->description;
                    $this->employee = Employee::find($timesheet->employee_id);

                    $this->full_name = $this->employee->full_name;

                    \Mail::to($admin)->queue(new TimesheetApproval($this->data));

                    $timesheet->update(['approver_level' => 'level_2']);
                }
            }
        }
        if ($request->status == 'Approve' && admin()->approver_level == 'level_2') {
            $timesheet->update(['approver_level' => 'Approved']);
        }

        return Reply::success('Timesheet updated successfully');
    }
}
