<?php

namespace App\Mail;

use App\Traits\Settings;

class TimesheetApproval extends BaseMail
{
    use Settings;
    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        parent::__construct();
        $this->data = $data;
        $this->setMailConfigs();
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        error_log('trying to send emails==================================>');
        return $this->replyTo($this->data['replyTo'])
            ->subject(__('email.timesheetApproval', ['company' => $this->data['active_company']->company_name]))
            ->view('emails.front.timesheet_approval')
            ->with($this->data);
    }
}
