@extends('admin.adminlayouts.adminlayout')

@section('head')
<!-- BEGIN PAGE LEVEL STYLES -->
{!! HTML::style("assets/global/plugins/bootstrap-select/css/bootstrap-select.min.css")!!}
{!! HTML::style("assets/global/plugins/select2/css/select2.css")!!}
{!! HTML::style("assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css") !!}
{!! HTML::style("assets/global/plugins/jquery-multi-select/css/multi-select.css")!!}
{!! HTML::style("assets/global/plugins/typeahead/typeahead.css")!!}
{!! HTML::style("assets/global/plugins/bootstrap-summernote/summernote.css")!!}
<!-- BEGIN THEME STYLES -->

@stop


@section('mainarea')


<!-- BEGIN PAGE HEADER-->
<div class="page-head">
    <div class="page-title">
        <h1>
            {{$pageTitle}}
        </h1>
    </div>
</div>
<div class="page-bar">
    <ul class="page-breadcrumb breadcrumb">
        <li>
            <a onclick="loadView('{{route('admin.projects.index')}}')">Projects</a>
            <i class="fa fa-circle"></i>
        </li>
        
        <li>
            <span class="active">{{__('core.btnAddTask')}}</span>
        </li>
    </ul>

</div>
<!-- END PAGE HEADER-->
<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->

        {{--INLCUDE ERROR MESSAGE BOX--}}

        {{--END ERROR MESSAGE BOX--}}


        <div class="portlet light bordered">


            <div class="portlet-body form">
                {!! Form::open(['class'=>'form-horizontal ajax_form','method'=>'POST']) !!}
                <!-- BEGIN FORM-->


                <div class="form-body">

                <input type="hidden" value="{{$project_id}}" name="project_id">
                    <div class="form-group">
                        <label class="col-md-2 control-label">{{trans('core.task_description')}} : <span class="required">
                                * </span>
                        </label>

                        <div class="col-md-6">
                            <textarea class="form-control" id="description" name="description"></textarea>
                            <span class="help-block"></span>
                        </div>
                    </div>                    
                  

                    <!-- END FORM-->

                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-offset-2 col-md-9">

                            <button type="button" id="taskCreate" class="btn green" onclick="ajaxCreateTask()">
                                {{trans('core.btnSubmit')}} </button>

                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
</div>
<!-- END PAGE CONTENT-->



@stop

@section('footerjs')

<!-- BEGIN PAGE LEVEL PLUGINS -->
{!! HTML::script("assets/global/plugins/bootstrap-select/js/bootstrap-select.min.js")!!}
{!! HTML::script("assets/global/plugins/select2/js/select2.min.js")!!}
{!! HTML::script("assets/global/plugins/jquery-multi-select/js/jquery.multi-select.js")!!}
{!! HTML::script("assets/global/plugins/bootstrap-summernote/summernote.min.js")!!}
{!! HTML::script("assets/global/plugins/typeahead/typeahead.bundle.min.js")!!}
{!! HTML::script("assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js") !!}
{{--{!! HTML::script('assets/admin/pages/scripts/components-pickers.js')!!}--}}
{!! HTML::script('assets/js/ajaxform/jquery.form.min.js')!!}
<script>
    //	 ComponentsPickers.init();
    $('#description').summernote({
        height: 300
    });


    function ajaxCreateTask() {

        console.log($(".ajax_form").serialize());
        $.easyAjax({
            url: "{!! route('admin.tasks.store') !!}",
            type: "POST",
            data: $(".ajax_form").serialize(),
            container: ".ajax_form",
        });
    }
</script>
<!-- END PAGE LEVEL PLUGINS -->
@stop