@extends('admin.adminlayouts.adminlayout')

@section('head')

    <!-- BEGIN PAGE LEVEL STYLES -->
    {!! HTML::style('assets/global/plugins/uniform/css/uniform.default.min.css')!!}
    {!! HTML::style("assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css")!!}
    {!! HTML::style("assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css")!!}
    {!! HTML::style("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css")!!}
    {!! HTML::style("assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css")!!}
    {!! HTML::style("assets/global/plugins/bootstrap-form-editable/bootstrap3-editable/css/bootstrap-editable.css")!!}
@stop

@section('mainarea')


    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                Timesheet Reports
            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('{{route('admin.dashboard.index')}}')">@lang('core.dashboard')</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active">Timesheet Reports</span>

            </li>

        </ul>

    </div>
    <!-- END PAGE HEADER-->

    <div id="load">
        {{--INLCUDE ERROR MESSAGE BOX--}}

        {{--END ERROR MESSAGE BOX--}}
    </div>
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
            <div class="row">
            <div class="col-md-2">
            <select class="form-control select2me" name="employee_id" id="employeeID">
                                    <option value="all">@lang('core.selectEmployee')</option>
                                    @foreach($employees as $employee)
                                        <option value="{{$employee->id}}">{{$employee->full_name}} (@lang('core.empId'): {{ $employee->employeeID }})</option>
                                    @endforeach
                                </select>

                                
            </div>
            <div class="col-md-4">
                <div class="row">
                    <div class="col-sm-6">
                    <div class="input-group input-medium date date-picker "
                                             data-date-viewmode="years" id="start_date">
                                            <input type="text" class="form-control " name="date"
                                                   placeholder="@lang("core.selectDate")"
                                                    id="start" value="{{ date('d/m/Y') }}">
                                            <span class="input-group-btn">
															   <button class="btn default" type="button"><i
                                                                           class="fa fa-calendar"></i></button>
															   </span>
                                        </div>
                    </div>
                    
                    <div class="col-sm-6">
                    <div class="input-group input-medium date date-picker "
                                             data-date-viewmode="years" id="end_date">
                                            <input type="text" class="form-control " name="date"
                                                   placeholder="@lang("core.selectDate")"
                                                    id="end" value="{{ date('d/m/Y') }}">
                                            <span class="input-group-btn">
															   <button class="btn default" type="button"><i
                                                                           class="fa fa-calendar"></i></button>
															   </span>
                                        </div>
                    </div>
                </div>
                                        

                                        

            
                                   
            </div>
            <div class="col-md-6" style="text-align: right;"><button class="btn success"><a id="report_link"  href=""  onmouseover="setParams();">Generate Report</a> </button></div>
            </div>
                <div class="portlet-body">
                    <div class="table-toolbar">
                        <div class="row">
                            <div class="col-md-6">
                                <a class="label green" onclick="alert(0)">
                                    
                                    <i class="fa fa-plus"></i> </a>
                            </div>
                            <div class="col-md-6">
                            </div>
                        </div>
                    </div>

                    <table class="table table-striped custom-table datatable dataTable no-footerr" id="timesheetReports">
                        <thead>
                        <tr>
                            <th> Employee</th>
                            <th> Project</th>
                            <th> Task  </th>
                            <th> Description  </th>
                            <th> From  </th>
                            <th> To  </th>
                            <th> Hours  </th>
                        </tr>
                        </thead>
                        <tbody>


                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->

        </div>
    </div>
    <!-- END PAGE CONTENT-->

    {{--MODAL CALLING--}}
    @include('admin.common.delete')
    @include('admin.common.show-modal')
    {{--MODAL CALLING END--}}

@stop


@section('footerjs')

    <!-- BEGIN PAGE LEVEL PLUGINS -->


    {!! HTML::script("assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js")!!}
    {!! HTML::script('assets/global/plugins/uniform/jquery.uniform.min.js')!!}
    {!! HTML::script("assets/global/plugins/moment.min.js") !!}
    {!! HTML::script("assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js")!!}
    {!! HTML::script("assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js")!!}
    {!! HTML::script("assets/global/plugins/datatables/datatables.min.js")!!}
    {!! HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js")!!}
    {!! HTML::script("assets/global/plugins/datatables/plugins/responsive/dataTables.responsive.min.js")!!}
    {!! HTML::script("assets/admin/pages/scripts/components-pickers.js")!!}
    {!! HTML::script('assets/js/ajaxform/jquery.form.min.js')!!}
    {!! HTML::script('assets/js/commonjs.js')!!}
    {!! HTML::script('assets/global/plugins/bootstrap-form-editable/bootstrap3-editable/js/bootstrap-editable.min.js')!!}

    <!-- END PAGE LEVEL PLUGINS -->

    <script>

$('.timepicker').timepicker({
            autoclose: true,
            minuteStep: 5,
            disableMousewheel: true,
            disableFocus: true
        });
var bindDatePicker = function (element) {
            $(element).timepicker({
                autoclose: true,
                minuteStep: 5,
                disableMousewheel: true,
                disableFocus: true
            });
        };


        $('#start_date').datepicker({
            format: "dd/mm/yyyy",
            todayHighlight: true,
            toggleActive: true,
            autoclose: true
        });

       

        $.fn.select2.defaults.set("theme", "bootstrap");
        $('.select2me').select2({
            placeholder: "Select",
            width: '100%',
            allowClear: false
        });

        var table = $('#timesheetReports').dataTable({
            "cache": true,
            "bProcessing": true,
            "bServerSide": true,
            "bDestroy": true,
            "order": [[1, "asc"]],
            "ajax": "{{ URL::route("admin.timesheet_reports.ajax_list") }}",
            "aoColumns": [
                {data: 'full_name', name: 'Employee'},
                {data: 'project', name: 'Project'},
                {data: 'task', name: 'task', "searchable": false},
                {data: 'description', name: 'description', "searchable": false},
                {data: 'from', name: 'From'},
                {data: 'to', name: 'To'},
                {data: 'hours', name: 'Hours'}
            ],
            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            "language": {
                "emptyTable": "No data available",
                "search": '',
                "searchPlaceholder": "Search..."
            },
            "sPaginationType": "full_numbers",
            "fnRowCallback": function (nRow, aData, iDisplayIndex) {
                var row = $(nRow);
                row.attr("id", 'row' + aData['0']);
            }

        });

        $('#end_date').datepicker({
            format: "dd/mm/yyyy",
            todayHighlight: true,
            toggleActive: true,
            autoclose: true
        }).on('changeDate', function(e){
            var emploee_id = $('#employeeID').val();

            if(emploee_id == "all"){
                toastr.error("Select employee and try again.");
                return;
            }

            var startDate = $('#start').val().substring(6,10) + "-" + $('#start').val().substring(3,5) + "-" + $('#start').val().substring(0,2);
            var endDate = $('#end').val().substring(6,10) + "-" + $('#end').val().substring(3,5) + "-" + $('#end').val().substring(0,2);

            var a = document.getElementById('report_link'); //or grab it by tagname etc
            a.href = "{{route('admin.timesheet_reports.download')}}?employee_id=" + emploee_id + "&start_date=" + startDate + "&end_date=" + endDate


            $('#timesheetReports').DataTable().destroy();
 
            $('#timesheetReports').dataTable({
            "cache": true,
            "bProcessing": true,
            "bServerSide": true,
            "bDestroy": true,
            "order": [[1, "asc"]],
            "ajax": "{{route('admin.timesheet_reports.ajax_list')}}?employee_id=" + emploee_id + "&start_date=" + startDate + "&end_date=" + endDate,
            "aoColumns": [
                {data: 'full_name', name: 'Employee'},
                {data: 'project', name: 'Project'},
                {data: 'task', name: 'task', "searchable": false},
                {data: 'description', name: 'description', "searchable": false},
                {data: 'from', name: 'From'},
                {data: 'to', name: 'To'},
                {data: 'hours', name: 'Hours'}
            ],
            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            "language": {
                "emptyTable": "No data available",
                "search": '',
                "searchPlaceholder": "Search..."
            },
            "sPaginationType": "full_numbers",
            "fnRowCallback": function (nRow, aData, iDisplayIndex) {
                var row = $(nRow);
                row.attr("id", 'row' + aData['0']);
            }

        });
        });
        

        function showEdit(id) {
            var url = "{{ route('admin.timesheet_approval.edit',':id') }}";
            url = url.replace(':id', id);
            $.ajaxModal('#showModal', url);

        }

        function showAdd() {
            var url = "{{ route('admin.leavetypes.create') }}";
            $.ajaxModal('#showModal', url);

        }

        function addUpdateTimesheet(id) {

            if (typeof id != 'undefined') {
                var url = "{{ route('admin.timesheet_approval.update',':id') }}";
                url = url.replace(':id', id);
            } else {
                url = "{{route('admin.timesheet_approval.store')}}";
            }
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '#timesheet_reports_update_form',
                data: $('#timesheet_reports_update_form').serialize(),
                success: function (response) {
                    if (response.status == "success") {
                        $('#showModal').modal('hide');
                        table.fnDraw();
                    }

                }
            });
        }

        function setParams(){
            var emploee_id = $('#employeeID').val();

            if(emploee_id == "all"){
                toastr.error("Select employee and try again.");
                return;
            }

            var startDate = $('#start').val().substring(6,10) + "-" + $('#start').val().substring(3,5) + "-" + $('#start').val().substring(0,2);
            var endDate = $('#end').val().substring(6,10) + "-" + $('#end').val().substring(3,5) + "-" + $('#end').val().substring(0,2);

            var a = document.getElementById('report_link'); //or grab it by tagname etc
            a.href = "{{route('admin.timesheet_reports.download')}}?employee_id=" + emploee_id + "&start_date=" + startDate + "&end_date=" + endDate
        }
    </script>
@stop
