<?php $__env->startSection("title"); ?>
    <?php echo e(__('home.title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection("css"); ?>
    <style type="text/css">
        .videoWrapper {
            position: relative;
            padding-bottom: 56.25%; /* 16:9 */
            padding-top: 25px;
            height: 0;
        }

        .videoWrapper iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>

    <section id="main-slider" class="no-margin">
        <div class="carousel slide">
            <div class="carousel-inner">
                <div class="item active"
                     style="background-image: url(<?php echo e(asset('assets/site/images/slider/dashboard_home_1600.jpg')); ?>);">
                    <div class="container">
                        <div class="row slide-margin">
                            <div class="col-sm-6">
                                <div class="carousel-content">
                                    <h1 class="animation animated-item-1"
                                        style="text-shadow: 0 3px 6px rgba(0,0,0,0.2)">
                                        <?php echo e(__('home.text1Acomplete')); ?></h1>
                                    <h2 class="animation animated-item-2"
                                        style="text-shadow: 0 3px 6px rgba(0,0,0,0.2); margin: 18px 0; font-weight: 400;"><?php echo e(__('home.trustText')); ?> <?php echo e($setting->main_name); ?></h2>
                                    <form id="sign-up-form-1" method="post"
                                          class="form-inline animation animated-item-3" action="<?php echo e(route("signup")); ?>">
                                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"/>
                                        <div class="form-group">
                                            <input type="text" name="email" class="form-control input-lg"
                                                   required="required" placeholder="<?php echo e(__('home.YourEmailID')); ?>"/>
                                        </div>
                                        <input type="submit" name="submit" class="input-lg btn btn-primary"
                                               value="Try for FREE!"/>
                                    </form>
                                    <h2 class="animation animated-item-2"<?php echo e(__('home.noCreditCard')); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!--/.item-->
            </div><!--/.carousel-inner-->
        </div><!--/.carousel-->
    </section><!--/#main-slider-->

    <section id="feature">
        <div class="container">
            <div class="center wow fadeInDown">
                <h2><?php echo e(__('home.whyWillYou')); ?> <i class="fa fa-heart"></i> <?php echo e($setting->main_name); ?></h2>
            </div>

            <div class="row">
                <div class="features">
                    <div class="col-md-6 col-sm-12 wow fadeInDown" data-wow-duration="1000ms" data-wow-delay="600ms">
                        <div class="feature-wrap">
                            <i class="fa fa-<?php echo e(strtolower($setting->currency)); ?>"></i>
                            <h2><?php echo e(__('home.PayFixedMonthly')); ?></h2>
                            <h3><?php echo e(__('home.PayFixedMonthlyDescription')); ?></h3>
                        </div>
                    </div><!--/.col-md-4-->

                    <div class="col-md-6 col-sm-12 wow fadeInDown" data-wow-duration="1000ms" data-wow-delay="600ms">
                        <div class="feature-wrap">
                            <i class="fa fa-thumbs-o-up"></i>
                            <h2><?php echo e(__('home.EasyToUse')); ?></h2>
                            <h3><?php echo e(__('home.EasyToUseDescription')); ?></h3>

                        </div>
                    </div><!--/.col-md-4-->

                    <div class="col-md-6 col-sm-12 wow fadeInDown" data-wow-duration="1000ms" data-wow-delay="600ms">
                        <div class="feature-wrap">
                            <i class="fa fa-mobile"></i>
                            <h2><?php echo e(__('home.MobileFriendly')); ?></h2>
                            <h3><?php echo e(__('home.MobileFriendlyDescription')); ?></h3>
                        </div>
                    </div><!--/.col-md-4-->


                    <div class="col-md-6 col-sm-12 wow fadeInDown" data-wow-duration="1000ms" data-wow-delay="600ms">
                        <div class="feature-wrap">
                            <i class="fa fa-rocket"></i>
                            <h2><?php echo e(__('home.EverImproving')); ?></h2>
                            <h3><?php echo e(__('home.EverImprovingDescription')); ?></h3>
                        </div>
                    </div><!--/.col-md-4-->
                </div><!--/.services-->
            </div><!--/.row-->
        </div><!--/.container-->
    </section><!--/#feature-->



    <section>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="center">
                        <h2><?php echo e(__('home.GetStartedToday')); ?></h2>
                        <p class="lead"><?php echo __('home.signUpAndStart'); ?>

                        </p>
                        <form id="sign-up-form-1" method="post" class="form-inline" action="<?php echo e(route("signup")); ?>">
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"/>
                            <div class="form-group">
                                <input type="text" name="email" class="form-control input-lg" required="required"
                                       placeholder="<?php echo e(__('home.YourEmailID')); ?>"/>
                            </div>
                            <input type="submit" name="submit" class="input-lg btn btn-primary" value="<?php echo e(__('home.signUp')); ?>"/>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <img class="img-responsive" src="<?php echo e(asset('assets/site/images/dashboard_bottom_1600_1.jpg')); ?>" width="100%"/>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("site.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dmwachinga/projects/hr/KodiHRM/resources/views/site/home.blade.php ENDPATH**/ ?>