<!DOCTYPE html>
<!--[if IE 8]>
<html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]>
<html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en"> <!--<![endif]-->
<head>
    <title><?php echo e($setting->company_name); ?> - <?php echo e($pageTitle); ?> </title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>

    <!-- CSS Global Compulsory -->
<?php echo HTML::style('front_assets/plugins/bootstrap/css/bootstrap.min.css'); ?>

<?php echo HTML::style('front_assets/css/style.css?v=2'); ?>

<!-- CSS Implementing Plugins -->

<?php echo HTML::style('front_assets/plugins/font-awesome/css/font-awesome.min.css'); ?>

<?php echo HTML::style('front_assets/plugins/sky-forms/version-2.0.1/css/custom-sky-forms.css'); ?>


<?php echo HTML::style('front_assets/plugins/scrollbar/src/perfect-scrollbar.css'); ?>

<?php echo HTML::style('front_assets/plugins/fullcalendar/fullcalendar.css'); ?>

<?php echo HTML::style('front_assets/plugins/fullcalendar/fullcalendar.print.css',array('media' => 'print')); ?>



<!-- CSS Page Style -->
<?php echo HTML::style('front_assets/css/pages/profile.css'); ?>




<!-- CSS Theme -->
<?php echo HTML::style("front_assets/css/theme-colors/$setting->front_theme.css"); ?>

<?php echo HTML::style('assets/global/plugins/uniform/css/uniform.default.min.css'); ?>

<!-- CSS Customization -->
    <link rel="icon" href="<?php echo e($setting->favicon_image_url); ?>" sizes="16x16">

    <?php echo HTML::style('front_assets/css/custom.css'); ?>

    <?php echo HTML::style('assets/global/plugins/froiden-helper/helper.css'); ?>

    <?php echo $__env->yieldContent('head'); ?>

</head>

<body>
<div class="wrapper">
    <!--=== Header ===-->
    <div class="header">
        <!-- Navbar -->
        <div class="navbar navbar-default mega-menu" role="navigation">
            <div class="container">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse"
                            data-target=".navbar-responsive-collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="fa fa-bars"></span>
                    </button>
                    <a class="navbar-brand" href="<?php echo e(route('dashboard.index')); ?>">
                        <?php echo HTML::image($setting->logo_image_url,'Logo',array('class'=>'logo-default','id'=>'logo-header','height'=>'30px')); ?>


                    </a>
                </div>

                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse navbar-responsive-collapse">
                    <ul class="nav navbar-nav">
                    <?php if($active_company->license_expired != 1): ?>

                        <!-- Home -->
                            <li class="<?php echo e(isset($homeActive) ? $homeActive : ''); ?>">
                                <a href="<?php echo e(route('dashboard.index')); ?>">
                                    <?php echo e(__('menu.home')); ?>

                                </a>
                            </li>
                            <!-- End Home -->
                        <?php if($setting->leave_feature==1): ?>
                            <!-- Leave -->
                                <li class="dropdown <?php echo e(isset($leaveActive) ? $leaveActive : ''); ?>">
                                    <a href="" href="javascript:void(0);" class="dropdown-toggle"
                                       data-toggle="dropdown">
                                        <?php echo e(__('menu.leave')); ?>

                                    </a>
                                    <ul class="dropdown-menu">
                                        <li><a href=""
                                               onclick="leaveModal();return false;"> <?php echo e(__('menu.applyLeave')); ?></a></li>
                                        <li><a href="<?php echo e(route('leaves.index')); ?>"> <?php echo e(__('menu.myLeave')); ?></a></li>

                                    </ul>
                                </li>
                        <?php endif; ?>
                        <!-- Leave -->
                            <li class="dropdown <?php if(isset($salaryActive)): ?> <?php echo e($salaryActive); ?> <?php elseif(Route::is("front.expenses.index")): ?> open <?php endif; ?>">
                                <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                                    <?php echo app('translator')->get('menu.self'); ?>
                                </a>
                                <ul class="dropdown-menu">
                                    <?php if($setting->payroll_feature==1): ?>
                                        <li><a href="<?php echo e(route('front.salary')); ?>"> <?php echo e(__('menu.salarySlip')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($setting->expense_feature==1): ?>
                                        <li>
                                            <a href="<?php echo e(route('front.expenses.index')); ?>"> <?php echo e(trans('menu.expenseFront')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                            <!-- End Leave -->
                            <!-- End Home -->
                            <!-- Job -->
                            <?php if($setting->jobs_feature==1): ?>
                                <li class="<?php echo e(isset($jobActive) ? $jobActive : ''); ?>">
                                    <a href="<?php echo e(route('jobs.index')); ?>">
                                        <?php echo e(__('menu.job')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        <!-- Job -->
                            <?php if($setting->mark_attendance==1 && $setting->attendance_setting_set == 1): ?>
                                

                                <li class="dropdown <?php echo e(isset($attendanceActive) ? $attendanceActive : ''); ?>">
                            <a href="" href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                            <?php echo e(__('core.attendance')); ?>

                            </a>

                            <ul class="dropdown-menu">

                                <?php if($active_company->license_expired != 1): ?>
                                    <li><a href="<?php echo e(route('front.attendance.index')); ?>">
                                        <?php echo e(__('core.attendance')); ?>

                                    </a></li>
                                <?php endif; ?>
                            <!-- Logout -->
                                <?php if(auth()->guard('employee')->check()): ?>
                                
                                    <li>
                                        <a href="front/timesheet">
                                            <?php echo e(__('menu.timesheet')); ?>

                                        </a>

                                    </li>
                            <?php endif; ?>
                            <!-- End Logout -->

                            </ul>
                        </li>

                                
                        <?php endif; ?>

                        
                    <?php endif; ?>
                    <!-- My Account -->
                        <li class="dropdown <?php echo e(isset($accountActive) ? $accountActive : ''); ?>">
                            <a href="" href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                                <?php echo e(__('menu.myAccount')); ?>

                            </a>

                            <ul class="dropdown-menu">

                                <?php if($active_company->license_expired != 1): ?>
                                    <li><a href="" data-toggle="modal" data-target=".change_password_modal"
                                           id="change_password_link"> <?php echo e(__('menu.changePassword')); ?></a></li>
                                <?php endif; ?>
                            <!-- Logout -->
                                <?php if(auth()->guard('employee')->check()): ?>
                                    <li>
                                        <a href="<?php echo e(route('front.logout')); ?>">
                                            <?php echo e(__('menu.logout')); ?>

                                        </a>

                                    </li>
                            <?php endif; ?>
                            <!-- End Logout -->

                            </ul>
                        </li>
                        <!-- End Leave -->

                    </ul>
                </div><!--/navbar-collapse-->
            </div>
        </div>

        <!-- End Navbar -->
    </div>

    <!--=== End Header ===-->

    <!--=== Profile ===-->
    <div class="profile container content">

        
        <?php echo $__env->make('maintenance_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        


        <div class="row">
            <!--Left Sidebar-->
            <div class="col-md-3 md-margin-bottom-40 <?php if(!isset($homeActive)): ?>hidden-sm hidden-xs <?php endif; ?>">
                <?php echo HTML::image($employee->profile_image_url,'ProfileImage',['class'=>"img-responsive profile-img margin-bottom-20",'style'=>'border:1px solid #ddd;margin:0 auto']); ?>



                
                <p>
                <h3 class="text-center"><?php echo e($employee->full_name); ?></h3>
                <h6 class="text-center"><?php echo e($employee->getDesignation->designation); ?></h6>
                <h6 class="service-block-u" style="text-align: center;padding: 10px;">
                    <strong><?php echo e(__('core.atWorkFor')); ?> : </strong><?php echo e($employee->work_duration); ?></h6>
                </p>
                <hr>
                <div class="service-block-v3 service-block-u">
                    <!-- STAT -->
                    <div class="row profile-stat">
                        <div class="col-md-4 col-sm-4 col-xs-6" data-toggle="tooltip" data-placement="bottom"
                             title="<?php echo date('F'); ?>">
                            <div class="uppercase profile-stat-title">
                                <?php echo e($attendance_count); ?>

                            </div>
                            <div class="uppercase profile-stat-text">
                                <?php echo e(__('core.attendance')); ?>

                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-6" data-toggle="tooltip" data-placement="bottom"
                             title="<?php echo e(__('core.leaves')); ?>">
                            <div class="uppercase profile-stat-title">
                                <?php echo e($leaveLeft); ?>

                            </div>
                            <div class="uppercase profile-stat-text">
                                <?php echo e(__('core.leaves')); ?>

                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-6" data-toggle="tooltip" data-placement="bottom"
                             title="<?php echo e(__('core.totalAwardsWon')); ?>">
                            <div class="uppercase profile-stat-title">
                                <?php echo e(count($employee->awards)); ?>

                            </div>
                            <div class="uppercase profile-stat-text">
                                <?php echo e(__('core.awards')); ?>

                            </div>
                        </div>
                    </div>
                    <!-- END STAT -->
                </div>


                <!--Notification-->
                <?php if(count($current_month_birthdays)>0): ?>
                    <div class="panel-heading-v2 overflow-h">
                        <h2 class="heading-xs pull-left"><i
                                class="fa fa-birthday-cake"></i> <?php echo e(__('core.birthdays')); ?></h2>
                    </div>
                    <ul id="scrollbar5" class="list-unstyled contentHolder margin-bottom-20" style="height: auto">
                        <?php $__currentLoopData = $current_month_birthdays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $birthday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="notification">
                                <?php echo HTML::image($birthday->profile_image_url,'ProfileImage',['class'=>"rounded-x"]); ?>



                                <div class="overflow-h">
                                    <span><strong><?php echo e($birthday->full_name); ?></strong>  <?php echo e(__('core.hasBirthDayOn')); ?></span>
                                    <strong><?php echo date('d F',strtotime($birthday->date_of_birth)); ?></strong>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
            <?php endif; ?>
            <!--End Notification-->


                <div class="margin-bottom-50"></div>
            </div>
            <!--End Left Sidebar-->

            
            <?php echo $__env->yieldContent('mainarea'); ?>
            


        </div><!--/end row-->


    </div>
    <!--=== End Profile ===-->

    <!--=== Footer Version 1 ===-->
    <div class="footer-v1">

        <div class="copyright">
            <div class="container">
                <div class="row">
                    <div class="col-md-4"></div>
                    <div class="col-md-4">
                        <p style="text-align: center;">
                            <?php echo date('Y'); ?> &copy; <?php echo e($setting->company_name); ?>


                        </p>
                    </div>

                    <!-- Social Links -->
                    <div class="col-md-4">

                    </div>
                    <!-- End Social Links -->
                </div>
            </div>
        </div><!--/copyright-->
    </div>
    <!--=== End Footer Version 1 ===-->


    

    <div class="modal fade apply_modal in" id="applyLeave" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">


            </div>
        </div>
    </div>

    <div class="modal fade apply_modal in" id="createTimesheet" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">


            </div>
        </div>
    </div>
    


    
    <div class="modal fade change_password_modal in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                    <h4 class="modal-title">
                        <?php echo e(__('menu.changePassword')); ?>

                    </h4>
                </div>
                <div class="modal-body" id="change_password_modal_body">
                    

                </div>
            </div>
        </div>
    </div>
    


</div><!--/wrapper-->

<script src="https://cdn.ravenjs.com/2.1.0/raven.min.js" rel="core"></script>

<!-- JS Global Compulsory -->
<?php echo HTML::script('front_assets/plugins/jquery/jquery.min.js'); ?>

<?php echo HTML::script('front_assets/plugins/jquery/jquery-migrate.min.js'); ?>

<?php echo HTML::script('front_assets/plugins/bootstrap/js/bootstrap.min.js'); ?>


<!-- JS Implementing Plugins -->
<?php echo HTML::script('front_assets/plugins/back-to-top.js'); ?>


<!-- Scrollbar -->
<?php echo HTML::script('front_assets/plugins/scrollbar/src/jquery.mousewheel.js'); ?>

<?php echo HTML::script('front_assets/plugins/scrollbar/src/perfect-scrollbar.js'); ?>

<!-- JS Customization -->
<?php echo HTML::script('front_assets//plugins/sky-forms/version-2.0.1/js/jquery-ui.min.js'); ?>

<?php echo HTML::script('front_assets/plugins/sky-forms/version-2.0.1/js/jquery.form.min.js'); ?>

<!-- JS Page Level -->
<?php echo HTML::script('front_assets/plugins/lib/moment.min.js'); ?>

<?php echo HTML::script('assets/global/plugins/uniform/jquery.uniform.min.js'); ?>

<?php echo HTML::script('assets/global/plugins/froiden-helper/helper.js'); ?>

<?php echo $__env->yieldContent('footerjs'); ?>

<!--[if lt IE 9]>
<?php echo HTML::script('front_assets/plugins/respond.js'); ?>

<?php echo HTML::script('front_assets/plugins/html5shiv.js'); ?>

<![endif]-->
<script>
    jQuery(document).ready(function ($) {
        "use strict";
        $('.contentHolder').perfectScrollbar();

        /*$('#start_date').datepicker({
            dateFormat: 'dd/mm/yy',
            prevText: '<i class="fa fa-angle-left"></i>',
            nextText: '<i class="fa fa-angle-right"></i>',
            minDate: 0,

            onSelect: function (selectedDate) {

                var diff = ($("#end_date").datepicker("getDate") -
                    $("#start_date").datepicker("getDate")) /
                    1000 / 60 / 60 / 24 + 1; // days
                if ($("#end_date").datepicker("getDate") != null) {
                    $('#daysSelected').html(diff);
                    $('#days').val(diff);
                }
                $('#end_date').datepicker('option', 'minDate', selectedDate);
            }
        });
        $('#end_date').datepicker({
            dateFormat: 'dd/mm/yy',
            prevText: '<i class="fa fa-angle-left"></i>',
            nextText: '<i class="fa fa-angle-right"></i>',
            onSelect: function (selectedDate) {

                $('#start_date').datepicker('option', 'maxDate', selectedDate);

                var diff = ($("#end_date").datepicker("getDate") -
                    $("#start_date").datepicker("getDate")) /
                    1000 / 60 / 60 / 24 + 1; // days
                if ($("#start_date").datepicker("getDate") != null) {
                    $('#daysSelected').html(diff);
                    $('#days').val(diff);
                }

            }
        });*/

    });

    function leaveModal() {
        $.ajaxModal('#applyLeave', '<?php echo e(route('leaves.create')); ?>');
    }

    function timesheetModal() {
        $.ajaxModal('#createTimesheet', '<?php echo e(route('timesheets.create')); ?>');
    }
</script>


<script>
    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })
</script>

<script>
    $('input[type=checkbox]').uniform();


    // Show change password modal body
    $('#change_password_link').click(function () {

        $('#change_password_modal_body').css("padding", "100px");
        $('#change_password_modal_body').html('<?php echo HTML::image('front_assets/img/loader.gif'); ?>');
        $('#change_password_modal_body').attr('class', 'text-center');

        $.ajax({
            type: 'POST',
            url: "<?php echo e(route('front.change_password_modal')); ?>",

            data: {},
            success: function (response) {

                $('#change_password_modal_body').css("padding", "0px");
                $('#change_password_modal_body').removeClass('text-center');
                $('#change_password_modal_body').html(response);
            },

            error: function (xhr, textStatus, thrownError) {
                $('#change_password_modal_body').html('<div class="alert alert-danger">Error Fetching data</div>');
            }
        });

    });

    function change_password() {
        $.easyAjax({
            type: 'POST',
            url: "<?php echo e(route('front.change_password')); ?>",
            data: $('#change_password_form').serialize(),
            container: "#change_password_form",
            success: function (response) {
                if (response.status === "success") {
                    $('.change_password_modal').modal('hide');
                }
            }
        });
        return false;
    }


    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
</script>
</body>
</html>
<?php /**PATH /home/dmwachinga/projects/hr/KodiHRM/resources/views/front/layouts/frontlayout.blade.php ENDPATH**/ ?>