<?php $__env->startSection('head'); ?>
    
    <?php echo HTML::style("assets/global/css/plugins.css"); ?>

    <?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css"); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainarea'); ?>
    <div class="col-md-9">
        <!--Profile Body-->
        <div class="profile-body">
            <div class="row margin-bottom-20">
                <!--Profile Post-->
                <div class="col-sm-12">


                    
                    <div id="alert_message">
                        <?php if(Session::get('success')): ?>
                            <div class="alert alert-success"><i class="fa fa-check"></i> <?php echo e(Session::get('success')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    

                    <a href="<?php echo e(route('front.expenses.create')); ?>" class="btn-u field"><i
                            class="fa fa-plus"></i> <?php echo e(__('menu.addExpenseFront')); ?></a>
                    <hr>
                    <div class="panel ">
                        <div class="panel-heading service-block-u">
                            <h3 class="panel-title"><?php echo e($setting->currency_symbol); ?> <?php echo app('translator')->get('core.myExpenses'); ?></h3>
                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="expenses">
                                    <thead>
                                    <tr>
                                        <th> <?php echo e(trans('core.id')); ?></th>
                                        <th> <?php echo e(trans('core.item')); ?></th>
                                        <th> <?php echo e(trans('core.purchase_from')); ?> </th>
                                        <th> <?php echo e(trans('core.date')); ?></th>
                                        <th><?php echo e(trans('core.price')); ?> ( <?php echo e($setting->currency_symbol); ?> )</th>
                                        <th>Bill</th>
                                        <th><?php echo e(trans('core.status')); ?></th>


                                    </tr>
                                    </thead>
                                    <tbody>


                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                    <!--End Profile Post-->


                </div><!--/end row-->

                <hr>


            </div>
            <!--End Profile Body-->
        </div>

    </div>


    


    <div class="modal fade show_notice" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                    <h4 id="myLargeModalLabel" class="modal-title">
                        Leave Application
                    </h4>
                </div>
                <div class="modal-body" id="modal-data">
                    
                </div>
            </div>
        </div>
    </div>


    

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerjs'); ?>
    <?php echo HTML::script("assets/global/plugins/datatables/datatables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>


    <script>

        var table = $('#expenses').dataTable({
            <?php echo $datatabble_lang; ?>

            processing: true,
            serverSide: true,
            "ajax": "<?php echo URL::route("front.ajax_expenses"); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'item_name', name: 'item_name'},
                {data: 'purchase_from', name: 'purchase_from'},
                {data: 'purchase_date', name: 'purchase_date'},
                {data: 'price', name: 'price'},
                {data: 'bill', name: 'bill'},
                {data: 'status', name: 'status'},

            ],
            "lengthMenu": [
                [5, 15, 20, -1],
                [5, 15, 20, "All"] // change per page values here
            ],
            "sPaginationType": "full_numbers",

            "fnRowCallback": function (nRow, aData, iDisplayIndex) {
                var oSettings = this.fnSettings();
                $("td:first", nRow).html(oSettings._iDisplayStart + iDisplayIndex + 1);
                return nRow;
            }

        });


        function show_salary_slip(id) {
            $('#modal-data').html('<div class="text-center"><?php echo HTML::image('front_assets/img/loader.gif'); ?></div>');
            $.ajax({
                type: "GET",
                url: "<?php echo e(URL::to('salary_slip/"+id+"')); ?>"

            }).done(function (response) {
                $('#modal-data').html(response);
//
            });
        }


    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.frontlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/front/expense/index.blade.php ENDPATH**/ ?>