<?php $__env->startSection("title"); ?>
    Support - <?php echo e($setting->main_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('assets/site/plugins/froiden-helper/helper.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
    <section id="features">
        <div class="col-lg-10 col-lg-offset-1">
            <div class="container">
                <h2>Frequently Asked Questions (FAQs)</h2>

                <p>Please go through the following FAQs containing solutions to most common problems faced by our
                    customers.
                    You can submit a support request below if you cannot find solution to your problem in these
                    questions.</p>
                <p>&nbsp;</p>

                <div class="row">
                    <div class="col-md-12">
                        <div class="tab-wrap">
                            <div class="media">
                                <div class="parent pull-left">
                                    <ul class="nav nav-tabs nav-stacked">
                                        <?php $__currentLoopData = $faqCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faqCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li <?php if($loop->first): ?> class="active" <?php endif; ?>><a
                                                    href="#tab_<?php echo e($faqCategory->id); ?>" data-toggle="tab"
                                                    class="analistic-01">General
                                                    <?php echo e($faqCategory->name); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>

                                <div class="parent media-body">
                                    <div class="tab-content">
                                        <?php $__currentLoopData = $faqCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faqCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="tab-pane <?php if($loop->first): ?> active <?php endif; ?>"
                                                 id="tab_<?php echo e($faqCategory->id); ?>">
                                                <div class="media">

                                                    <div class="accordion">
                                                        <div class="panel-group" id="accordion_<?php echo e($faqCategory->id); ?>">
                                                            <?php $__currentLoopData = $faqCategory->faq; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="panel panel-default">
                                                                    <div
                                                                        class="panel-heading <?php if($loop->first): ?> active <?php endif; ?>">
                                                                        <h3 class="panel-title">
                                                                            <a class="accordion-toggle"
                                                                               data-toggle="collapse"
                                                                               data-parent="#accordion_<?php echo e($faqCategory->id); ?>"
                                                                               href="#collapse_<?php echo e($faq->id); ?>">
                                                                                <?php echo e($loop->iteration); ?>

                                                                                . <?php echo e($faq->title); ?>

                                                                                <i class="fa fa-angle-right pull-right"></i>
                                                                            </a>
                                                                        </h3>
                                                                    </div>

                                                                    <div id="collapse_<?php echo e($faq->id); ?>"
                                                                         class="panel-collapse collapse in">
                                                                        <div class="panel-body">
                                                                            <div class="media accordion-inner">
                                                                                <?php echo e($faq->content_text); ?>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div><!--/#accordion1-->
                                                    </div>


                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div> <!--/.tab-content-->
                                </div> <!--/.media-body-->
                            </div> <!--/.media-->
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">

                        <h2>Contact Us</h2>

                        <p>How can we help you? We will try to get back to you as soon as possible.</p>
                        <p>&nbsp;</p>


                        <form class="contact-form" id="contact_form" method="post" action="">
                            <div id="alert"></div>

                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"/>
                            <div class="form-group">
                                <label>Name:</label>
                                <input type="text" name="name" class="form-control"/>
                            </div>
                            <div class="form-group">
                                <label>Email:</label>
                                <input type="email" name="email" class="form-control"/>
                            </div>
                            <div class="form-group">
                                <label>I want help with:</label>
                                <select class="form-control" name="category">
                                    <option value="" disabled="disabled">— Choose a Category —</option>
                                    <option value="My Account">My Account</option>
                                    <option value="Billing">Billing</option>
                                    <option value="Feedback and Feature Requests">Feedback and Feature Requests</option>
                                    <option value="Something's Not Working">Something's Not Working</option>
                                    <option value="How do I...?">How do I...?</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Details of problem:</label>
                                <textarea name="details" class="form-control" rows="5"></textarea>
                            </div>
                            <div class="form-group">
                                <button type="button" name="submit" onclick="contactSubmit();return false;"
                                        class="btn btn-primary btn-lg">Submit
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <h2>Email</h2>
                        <p>You can also get in touch with us on our email: <a
                                href="mailto:support<?php echo e($setting->email); ?>"><?php echo e($setting->email); ?></a>.</p>
                        <p>&nbsp;</p>
                        <h2>Address</h2>

                        <p>
                            <?php echo $setting->address; ?>

                            .</p>
                    </div>

                </div>
            </div>
        </div>

        <div class="clearfix"></div>

    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>

    <script type="text/javascript" src="<?php echo e(asset('assets/site/plugins/froiden-helper/helper.js')); ?>"></script>

    <script type="text/javascript">
        function contactSubmit() {
            $.easyAjax({
                url: "<?php echo route('contact.submit'); ?>",
                type: "POST",
                data: $("#contact_form").serialize(),
                container: "#contact_form",
                messagePosition: "inline",
                removeElements: true
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("site.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/site/support.blade.php ENDPATH**/ ?>