<?php $__env->startSection('head'); ?>
    <!-- BEGIN PAGE LEVEL STYLES -->
    <?php echo HTML::style("assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css"); ?>

    <?php echo HTML::style("assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css"); ?>

    <?php echo HTML::style("assets/global/plugins/icheck/skins/all.css"); ?>

    <?php echo HTML::style("assets/global/plugins/select2/css/select2.css"); ?>

    <?php echo HTML::style("assets/global/plugins/select2/css/select2-bootstrap.min.css"); ?>

    <!-- BEGIN THEME STYLES -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


    <!-- BEGIN PAGE HEADER-->
    <div class="page-head">
        <div class="page-title"><h1>
                <?php echo e(trans('pages.expenses.editTitle')); ?>

            </h1></div>
    </div>
    <div class="page-bar">
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <a onclick="loadView('<?php echo e(route('admin.dashboard.index')); ?>')"><?php echo e(trans('core.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a onclick="loadView('<?php echo e(route('admin.expenses.index')); ?>')"><?php echo e(trans('pages.expenses.indexTitle')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span class="active"><?php echo e(trans('pages.expenses.editTitle')); ?></span>
            </li>
        </ul>

    </div>            <!-- END PAGE HEADER-->            <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->

            

            


            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-database font-dark"></i><?php echo e(trans('core.expenseDetails')); ?>

                    </div>
                    <div class="tools"></div>
                </div>

                <div class="portlet-body form">

                    <!-- BEGIN FORM-->
                    <?php echo Form::open(['class'=>'form-horizontal ajax_form','method'=>'PATCH','files'=>true]); ?>



                    <div class="form-body">

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.item')); ?> <span class="required">
                                * </span></label>

                            <div class="col-md-6">
                                <input type="text" class="form-control" name="item_name" id="item_name"
                                       placeholder="<?php echo e(trans('core.item')); ?>"
                                       value="<?php echo e($expense->item_name); ?>">
                                <span class="help-block"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.purchase_from')); ?> : </label>

                            <div class="col-md-6">
                                <input type="text" class="form-control" name="purchase_from"
                                       placeholder="<?php echo e(trans('core.purchase_from')); ?>"
                                       value="<?php echo e($expense->purchase_from); ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.date')); ?>:</label>

                            <div class="col-md-6">
                                <div class="input-group input-medium date date-picker" data-date-format="dd-mm-yyyy"
                                     data-date-viewmode="years">
                                    <input type="text" class="form-control" name="purchase_date" readonly
                                           value="<?php echo date('d-m-Y',strtotime($expense->purchase_date)); ?>">
                                    <span class="input-group-btn">
                                    <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                                </span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.price')); ?>:<span class="required">
                                * </span> <?php echo e($loggedAdmin->company->currency_symbol); ?></label>

                            <div class="col-md-6">
                                <input type="text" class="form-control" name="price" id="price"
                                       placeholder="Price of Item"
                                       value="<?php echo e($expense->price); ?>">
                                <span class="help-block"></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.paidBy')); ?>:<span
                                        class="required"> * </span></label>

                            <div class="col-md-6">
                                <select class="form-control select2me" name="employee_id">
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($employee->id); ?>"
                                                <?php if($employee->id==$expense->employee_id): ?>selected='selected'<?php endif; ?> ><?php echo e($employee->full_name); ?> (<?php echo app('translator')->get('core.empId'); ?>: <?php echo e($employee->employeeID); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo app('translator')->get("core.attachBill"); ?>:</label>
                            <input type="hidden" name="billhidden" value="<?php echo e($expense->bill); ?>">

                            <div class="col-md-6">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="input-group input-large">
                                        <div class="form-control uneditable-input" data-trigger="fileinput">
                                            <i class="fa fa-file fileinput-exists"></i>&nbsp; <span
                                                    class="fileinput-filename">
                                        </span>
                                        </div>
                                        <span class="input-group-addon btn default btn-file">
                                        <span class="fileinput-new">
                                            <?php echo e(trans('core.selectFile')); ?>  </span>
                                        <span class="fileinput-exists">
                                            <?php echo e(trans('core.change')); ?>  </span>
                                        <input type="file" name="bill">
                                    </span>
                                        <a href="#" class="input-group-addon btn red fileinput-exists"
                                           data-dismiss="fileinput">
                                            <?php echo e(trans('core.remove')); ?>  </a>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-4">


                                <?php if($expense->bill!=''): ?>
                                    <a href="<?php echo e($expense->bill_url); ?>" target="_blank"
                                       class="btn green"><?php echo app('translator')->get("core.viewBill"); ?></a>
                                <?php endif; ?>
                            </div>

                        </div>
                        <div class="form-group">
                            <label class="col-md-2 control-label"><?php echo e(trans('core.status')); ?>:<span class="required">
                                * </span></label>

                            <div class="col-md-6">
                                <div class="radio-list">
                                    <label class="radio-inline"><input type="radio" name="status"
                                                                       <?php if($expense->status=='approved'): ?> checked
                                                                       <?php endif; ?> class="icheck"
                                                                       value="approved"> <?php echo e(trans('core.approved')); ?>

                                    </label>
                                    <label class="radio-inline"><input type="radio" name="status"
                                                                       <?php if($expense->status=='pending'): ?> checked
                                                                       <?php endif; ?> class="icheck"
                                                                       value="pending"> <?php echo e(trans('core.pending')); ?>

                                    </label>
                                    <label class="radio-inline"><input type="radio" name="status"
                                                                       <?php if($expense->status=='rejected'): ?> checked
                                                                       <?php endif; ?> class="icheck"
                                                                       value="rejected"> <?php echo e(trans('core.rejected')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>


                        <!-- END FORM-->

                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-9">
                                <button type="button" data-loading-text=" <?php echo e(trans('core.btnUpdating')); ?>..."
                                        class=" btn green" id="expenseUpdate"
                                        onclick="ajaxUpdateExpense(<?php echo e($expense->id); ?>)"><i
                                            class="fa fa-edit"></i> <?php echo e(trans('core.btnUpdate')); ?> </button>

                            </div>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <!-- END EXAMPLE TABLE PORTLET-->

            </div>
        </div>
        <!-- END PAGE CONTENT-->

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerjs'); ?>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <?php echo HTML::script("assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js"); ?>

    <?php echo HTML::script("assets/admin/pages/scripts/components-pickers.js"); ?>

    <?php echo HTML::script("assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js"); ?>

    <?php echo HTML::script('assets/global/plugins/icheck/icheck.min.js'); ?>

    <?php echo HTML::script("assets/global/plugins/select2/js/select2.min.js"); ?>

    <?php echo HTML::script('assets/js/ajaxform/jquery.form.min.js'); ?>

    <!-- END PAGE LEVEL PLUGINS -->
    <script>
        jQuery(document).ready(function () {

            ComponentsPickers.init();
            $.fn.select2.defaults.set("theme", "bootstrap");
            $('.select2me').select2({
                placeholder: "Select",
                width: '100%',
                allowClear: false
            });
        });

        function ajaxUpdateExpense(id) {
            var url = "<?php echo e(route('admin.expenses.update',':id')); ?>";
            url = url.replace(':id', id);
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '.ajax_form',
                file: true,
            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kodiinit/hrm.kodiinitiative.org/resources/views/admin/expenses/edit.blade.php ENDPATH**/ ?>