<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\AdminBaseController;
use App\Http\Requests\Admin\Task\StoreRequest;
use App\Models\Task;
use Illuminate\Http\Request;

use App\Classes\Reply;
use App\Http\Requests\Admin\Task\DeleteRequest;
use Illuminate\Support\Facades\Session as FacadesSession;
use Illuminate\Support\Facades\View;

use Yajra\DataTables\Facades\DataTables;

class TasksController extends AdminBaseController
{
    //
    public function __construct()
    {
        parent::__construct();
        $this->pageTitle = trans('pages.projects.indexTitle');
        $this->projectsOpen = 'active';
        $this->projectsActive = 'active';
    }

    public function index(Request $request)
    {

        error_log('1 tasks request=============================>' . $request->project_id);

        //set in session task ID to be used in ajax request

        session()->put('project_id', $request->project_id);

        $this->data['project_id'] = $request->project_id;
        return View::make('admin.tasks.index', $this->data);
    }

      // Datatable ajax request
      public function ajax_tasks(Request $request)
      {

        $projectId = session()->get('project_id');
        error_log('2 tasks request=============================>' . $projectId);
          
          $result = Task::select('id', 'description', 'created_at')
                ->where('project_id', '=', $projectId)
                ->get();
  
              error_log($request->project_id . '=========================>' . count($result));
  
          return DataTables::of($result)
              ->addColumn('edit', function ($row) {
                  return '
                  <a  href="javascript:;" onclick="del(\'' . $row->id . '\');return false;" class="btn red btn-sm margin-bottom-5">      <i class="fa fa-trash"></i> ' . trans("core.btnDelete") . ' </a>
                    ';
              })
              ->rawColumns([ 'edit'])
              ->make();
      }

      public function create(Request $request)
    {

        $this->pageTitle = trans('pages.tasks.createTitle');
        $this->data['project_id'] = $request->project_id;
        return View::make('admin.tasks.create', $this->data);
    }

    public function store(StoreRequest $request)
    {

        $arrayValues = $request->toArray();

        Task::create($arrayValues);

        return Reply::redirect(route('admin.tasks.index') . '?project_id=' . $arrayValues['project_id'],'messages.addSuccess');
    }

    public function destroy(DeleteRequest $request, $id)
    {

        Task::destroy($id);

        return Reply::success('messages.taskDeleteMessage');
    }
}
