<?php

namespace App\Http\Requests\Admin\Project;

use App\Classes\Reply;
use App\Http\Requests\AdminCoreRequest;
use App\Models\Project;
use Illuminate\Support\Facades\Lang;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateRequest extends AdminCoreRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $project = Project::find($this->route('project'));
        return admin() && $project;
    }


    public function rules()
    {
        return [
            'name' => 'required',
            'description' => 'required|min:20'
        ];
    }
}
