<div class="modal-content">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
        <span class="caption-subject font-red-sunglo bold uppercase"><?php echo e(trans("core.leaveApplication")); ?></span>
    </div>
    <div class="modal-body">
        <div class="portlet-body form">
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.name"); ?></strong></label>
                <div class="col-md-9">
                    <?php echo e($leave_application->employee->full_name); ?>

                </div>
            </div>
            <br>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.leaveType"); ?></strong></label>
                <div class="col-md-9">
                    <?php if($leave_application->leaveType == 'half day'): ?>
                        <?php echo e(ucfirst($leave_application->leaveType)); ?> - <?php echo e($leave_application->halfDayType); ?>

                    <?php else: ?>
                        <?php echo e(ucfirst($leave_application->leaveType)); ?>

                    <?php endif; ?>
                </div>
            </div>
            <br>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.date"); ?></strong></label>
                <div class="col-md-9">
                    <?php if(!isset($leave_application->end_date)): ?>
                        <?php echo date('d-M-Y',strtotime($leave_application->start_date)); ?>

                    <?php else: ?>
                        <?php echo date('d-M-Y',strtotime($leave_application->start_date)); ?> - <?php echo date('d-M-Y',strtotime($leave_application->end_date)); ?>

                    <?php endif; ?>
                </div>
            </div>

            <br>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.leaveDays"); ?></strong></label>
                <div class="col-md-9">
                    <?php echo e($leave_application->days); ?>

                </div>
            </div>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.reason"); ?></strong></label>
                <div class="col-md-9">
                    <?php echo e($leave_application->reason); ?>

                </div>
            </div>
            <br>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.appliedOn"); ?></strong></label>
                <div class="col-md-9">
                    <?php echo date('d-M-Y',strtotime($leave_application->applied_on)); ?>

                </div>
            </div>
            <br>
            <div class="row">
                <label class="control-label col-md-3"><strong><?php echo app('translator')->get("core.status"); ?></strong></label>
                <div class="col-md-9 text-uppercase">
                    <?php if($leave_application->application_status=='rejected'): ?>
                        <span class="label label-danger"><?php echo e(trans("core.".$leave_application->application_status)); ?></span>
                    <?php elseif($leave_application->application_status == 'approved'): ?>
                        <span class="label label-success"><?php echo e(trans("core.".$leave_application->application_status)); ?></span>
                    <?php elseif($leave_application->application_status == 'pending'): ?>
                        <span class="label label-info"><?php echo e(trans("core.".$leave_application->application_status)); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <br>


        </div>
    </div>
    <div class="modal-footer">
        <?php if($leave_application->application_status=='pending'): ?>
            <div class="form-actions">
                <div class="row">
                    <div class="col-md-offset-3 col-md-9">
                        <input type="submit" name="application_status" data-loading-text="<?php echo app('translator')->get("core.updating"); ?>..." class="btn green" value="<?php echo e(trans("core.btnApprove")); ?>" data-toggle="modal" href="#static_approve" onclick="show_approve(<?php echo e($leave_application->id); ?>);return false;">
                        <input type="submit" name="application_status" data-loading-text="<?php echo app('translator')->get("core.updating"); ?>..." class="btn red" value="<?php echo e(trans("core.btnReject")); ?>" data-toggle="modal" href="#static_reject" onclick="show_reject(' <?php echo e($leave_application->id); ?> ');return false;">
                        <button type="button" data-dismiss="modal" class="btn dark btn-outline"><?php echo e(trans("core.btnCancel")); ?></button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    </div>
</div>

<?php /**PATH /home/dmwachinga/projects/hr/KodiHRM/resources/views/admin/leave_applications/show.blade.php ENDPATH**/ ?>